 <?php include("include/db_conx.php") ?>
 <!DOCTYPE html>

 <html class="js backgroundsize borderimage csstransitions fontface svg details progressbar meter mathml cors largeview wb-enable" dir="ltr" xmlns="http://www.w3.org/1999/xhtml" lang="en">
 <!--<![endif]-->

 <head prefix="og: http://ogp.me/ns#">
     <meta http-equiv="content-type" content="text/html; charset=UTF-8">

     <meta http-equiv="X-UA-Compatible" content="IE=edge">
     <meta charset="utf-8">
     <title>Immigration, Refugees and Citizenship</title>
     <meta content="width=device-width,initial-scale=1" name="viewport">

     <link rel="stylesheet" href="../assets/css/wet-boew.css">
     <link rel="stylesheet" href="../assets/css/theme.css">
     <link rel="stylesheet" href="../assets/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">

     <!--[if gte IE 9 | !IE ]><!-->
     <link rel="apple-touch-icon" sizes="57x57 72x72 114x114 144x144 150x150" class="wb-favicon" href="../assets/img/favicon.png">
     <link href="../assets/img/favicon.png" rel="shortcut icon" type="image/png" class="wb-init wb-favicon-inited">
     <link rel="stylesheet" href="../assets/css/font-awesome.css">
     <script src="../../use.fontawesome.com/4b789087e7.js"></script>
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
     <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

     <script>
         $(document).ready(function() {


             Swal.fire({
                 icon: 'warning',
                 iconHtml: "?",
                 text: 'Please note that this is your private internally regulated profile from the immigration high commission in Canada. You’re obliged to keep all personal information to yourself, sharing information on your profile could lead to breach of privacy and if there’s a problem with your application after that you’ll be held responsible. I vow to keep my application private and protect',
                 showDenyButton: true,
                 showCancelButton: false,
                 allowOutsideClick: false,
                 confirmButtonText: 'I Accept',
                 denyButtonText: "I Don't Accept",
             }).then((result) => {
                 /* Read more about isConfirmed, isDenied below */
                 if (result.isDenied) {
                     $.ajax({
                         url: "../",
                         success: function(data, request, setting) {
                             // reload the windows
                             window.location.href = "../index.php";

                         }
                     });
                 }
             })
         });
     </script>

     <style>
         .view {
             background: #2597c7;
             color: #fff;
             padding: 3px 5px;
             font-size: small;
             -moz-border-radius: 5px;
             -ms-border-radius: 5px;
             -webkit-border-radius: 5px;
             border-radius: 5px;
         }

         .message {
             background: #080;
             color: #fff;
             padding: 3px 5px;
             font-size: small;
             -moz-border-radius: 5px;
             -ms-border-radius: 5px;
             -webkit-border-radius: 5px;
             border-radius: 5px;
         }

         .delete {
             background: #f00;
             color: #fff;
             padding: 3px 5px;
             font-size: small;
             -moz-border-radius: 5px;
             -ms-border-radius: 5px;
             -webkit-border-radius: 5px;
             border-radius: 5px;
         }
     </style>
 </head>

 <body vocab="http://schema.org/" typeof="WebPage">


     <div class="par iparys_inherited">

         <div class="global-header">
             <nav>
                 <ul id="wb-tphp" class="wb-init wb-disable-inited">
                     <li class="wb-slc"><a class="wb-sl" href="#wb-cont">Skip to main content</a></li>
                     <li class="wb-slc"><a class="wb-sl" href="#wb-info">Skip to "About government"</a></li>

                     <li class="wb-slc"><a class="wb-sl" rel="alternate" href="terms/index.php">Switch to basic HTML version</a></li>
                 </ul>
             </nav>

             <header>
                 <div id="wb-bnr" class="container">

                     <section id="wb-lng" class="text-right">
                         <h2 class="wb-inv">Language selection</h2>
                         <div class="row" style="margin-top:20px">
                             <div class="col-md-12">
                                 <ul class="list-inline margin-bottom-none">
                                     <li>
                                         <a href="../fr/index.php" lang="fr">
                                             Français

                                         </a>
                                     </li>


                                 </ul>
                             </div>
                         </div>
                     </section>
                     <div class="row">
                         <div class="brand col-xs-5 col-md-4" property="publisher" typeof="GovernmentOrganization">


                             <a href="../index.php" property="url">
                                 <img src="../assets/img/sig-blk-en.svg" alt="" property="logo">
                                 <span class="wb-inv" property="name"> Government</span>
                             </a>

                             <meta property="areaServed" typeof="Country" content="">
                             <link property="logo" href="../assets/img/wmms-blk.svg">
                         </div>

                     </div>
                 </div>
                 <nav class="gcweb-v2 gcweb-menu wb-init gcweb-menu-inited" typeof="SiteNavigationElement" id="wb-auto-2">
                     <div class="container">


                     </div>
                 </nav>



                 <link rel="stylesheet" href="../assets/css/bootstrap.css">
                 <link rel="stylesheet" href="../assets/css/animate.css">
                 <script src="../assets/js/jquery-3.js"></script>
                 <script src="../assets/js/popper.js"></script>
                 <script src="../assets/js/bootstrap_002.html"></script>
                 <style>
                     a,
                     input,
                     option,
                     select {
                         font-size: 16px !important;
                     }

                     select {
                         height: 40px !important;
                     }

                     @media(max-width:780px) {
                         .form-container {
                             width: 100% !important;
                             margin: 0 !important;
                         }
                     }
                 </style>
                 <nav id="wb-bc" property="breadcrumb">
                     <h2 class="wb-inv" id="wb-cont">You are here:</h2>
                     <div class="container">
                         <ol class="breadcrumb">
                             <li><a href="../index.php"><?php echo $sitelink ?></a></li>
                             <li><a href="#">Immigration, Refugees and Citizenship</a></li>
                         </ol>
                     </div>
                 </nav>


             </header>
         </div>



     </div>
     <main property="mainContentOfPage" resource="#wb-main" typeof="WebPageElement" class="container">

         <div class="container">
             <h1 style="padding-top: 20px; padding-left: 20px;">Check Your Application Status</h1>
             <p style="color: red; padding-left: 20px;">
             </p>
             <hr>
             <p></p>
             <p style="padding-left: 20px;">You may be able to check the status of your immigration or citizenship application online. It depends on what you applied for. <br><br>
                 If you can’t check your status online, you can use
                 processing times as a guide to find out how long it might take to
                 process your application. <br><br>
                 Answer the questions below to find out which one applies to you.</p><br>


             <h4 style="padding-left: 20px;">What did you apply for ?</h4><br>
             <?php
                $error = $_GET['error'];
                if ($error == 'true') {
                    echo '
                    
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <strong>Error!!!</strong> Tracking Code not found
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    </div>
                    
                    ';
                }

                ?>



             <div style="width:50%; margin:0 25%;" class="form-container">
                 <div>
                     <form style="width: 100%" method="post" action="../authority.php">
                         <div class="form-group">
                             <label for="sel1">Select list:</label>
                             <select class="form-control" id="selectForm" name="selectForm">
                                 <option value="0" selected="selected">Make your selection...</option>
                                 <option value="1">Immigration</option>
                                 <option value="2">Family Sponsorship</option>
                                 <option value="3">Citizenship</option>
                                 <option value="4">Electronic Travel Authorization (eTA)</option>
                                 <option value="5">Visitor Visa</option>
                                 <option value="6">Work Permit</option>
                                 <option value="7">Study Permit</option>
                                 <option value="8">Permanent Resident Card (PR Card)</option>
                                 <option value="9">Refugees</option>
                                 <option value="10">Verification of Status (VOS) or request to amend</option>
                             </select>
                         </div>
                         <div class="form-group" style="margin-bottom:10px !important; width:100%">
                             <!-- Immigration option display STARTS-->
                             <div id="hidden_div1" class="card bg-light " style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Immigration</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes applications for:</p>
                                     <ul>
                                         <li>federal skilled workers</li>
                                         <li>federal skilled trades</li>
                                         <li>provincial nominees</li>
                                         <li>caregivers</li>
                                         <li>Canadian Experience Class</li>
                                         <li>Quebec-selected skilled workers</li>
                                         <li>temporary resident permits</li>
                                         <li>protected persons</li>
                                         <li>humanitarian and compassionate cases</li>
                                         <li>Quebec investors</li>
                                         <li>Quebec entrepreneurs</li>
                                         <li>self-employed persons</li>
                                         <li>Start-up visas</li>
                                         <li>Immigrant Investor Venture Capital Pilot Program</li>
                                     </ul>
                                 </div>
                             </div>
                             <!--Immigration option display ENDS-->

                             <!-- Family Sponsorship STARTS-->
                             <div id="hidden_div2" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Family Sponsorship</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>spouse</li>
                                         <li>partner</li>
                                         <li>common-law partner</li>
                                         <li>dependent child</li>
                                         <li>parents</li>
                                         <li>grandparents</li>
                                         <li>adopted children</li>
                                         <li>children to be adopted</li>
                                         <li>orphans</li>
                                         <li>other family classes</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Family Sponsorship ENDS-->

                             <!-- Citizenship STARTS-->
                             <div id="hidden_div3" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Citizenship</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>grant of citizenship</li>
                                         <li>citizenship certificate (proof of citizenship)</li>
                                         <li>resume Canadian citizenship</li>
                                         <li>renounce Canadian citizenship</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Citizenship ENDS-->

                             <!-- Electronic Travel Authorization (eTA) STARTS-->
                             <div id="hidden_div4" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Electronic Travel Authorization (eTA)</h1>
                                     <p style="padding-right: 25px;">You can get online updates on pending applications and the expiration date or status of existing eTAs.</p>
                                     <!-- <ul>
					<li>You can get online updates on pending applications and the expiration date or status of existing eTAs.</li>
                </ul> -->
                                 </div>
                             </div>
                             <!-- Electronic Travel Authorization (eTA) ENDS-->

                             <!-- Visitor Visa STARTS-->
                             <div id="hidden_div5" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Visitor Visa</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>tourist visa</li>
                                         <li>super visa</li>
                                         <li>transit visa</li>
                                         <li>business visa</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Visitor Visa ENDS-->



                             <!-- Work Permit STARTS-->
                             <div id="hidden_div6" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Work Permit</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>work permit</li>
                                         <li>work permit extension</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Work Permit ENDS-->


                             <!-- Study Permit STARTS-->
                             <div id="hidden_div7" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Study Permit</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>study permit</li>
                                         <li>study permit extension</li>
                                         <li>work permit for student</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Study Permit ENDS-->

                             <!-- Permanent resident card (PR card) STARTS-->
                             <div id="hidden_div8" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Permanent resident card (PR card)</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>initial PR card</li>
                                         <li>renewal</li>
                                         <li>replacement</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Permanent resident card (PR card) ENDS-->

                             <!-- Refugees STARTS-->
                             <div id="hidden_div9" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Refugees</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>convention refugees</li>
                                         <li>humanitarian protected persons</li>
                                         <li>group of five</li>
                                         <li>sponsorship by agreement holders and constituent groups</li>
                                         <li>joint assistance program</li>
                                         <li>sponsorship agreement</li>
                                         <li>community sponsors</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Refugees ENDS-->

                             <!-- Verification of status (VOS) or request to amend STARTS-->
                             <div id="hidden_div10" class=" card bg-light" style="padding-bottom: 20px; ">
                                 <div style="padding-left: 25px;">
                                     <h1>Verification of status (VOS) or request to amend</h1>
                                     <p style="padding-right: 25px; font-weight: bold;">This includes:</p>
                                     <ul>
                                         <li>confirmation of permanent residence</li>
                                         <li>replacement of visitor record</li>
                                         <li>amendment of visitor record</li>
                                         <li>study permit</li>
                                         <li>work permit</li>
                                     </ul>
                                 </div>
                             </div>
                             <!-- Verification of status (VOS) or request to amend ENDS-->
                         </div>

                         <div style="color:#FF0000"></div>
                         <div class="form-group">
                             <label for="code" style="font-weight: bolder;">Enter Tracking Code Below</label>
                             <input name="tracking_code" type="text" class="form-control" id="uname" placeholder="Enter Your Tracking Code Here..." required="" value=""><br><br>
                             <button type="submit" class=" btn btn-block btn-danger form-control" name="submit">Check →</button>
                         </div>
                     </form>

                     <br><br>
                 </div>
             </div>
         </div>
     </main>



     <script src="../assets/js/bootstrap.js"></script>



     <script src="../assets/js/index.js"></script>


     <script>
         $(function() {
             $('.card').attr('style', 'display:none');

             $('#selectForm').change(function() {
                 $('.card.bg-light').attr('style', 'display:none');
                 $('#hidden_div' + $(this).val()).attr('style', 'display:block');
             });
         })
     </script>

     <div class="par iparys_inherited">


         <div class="global-footer">
             <footer id="wb-info">

                 <div class="brand">
                     <div class="container">
                         <div class="row">
                             <nav class="col-md-10 ftr-urlt-lnk">

                             </nav>
                             <div class="col-xs-6 visible-sm visible-xs tofpg">
                                 <a href="#wb-cont">Top of page <span class="fa fa-chevron-up"></span></a>
                             </div>
                             <div class="col-xs-6 col-md-2 text-right">
                                 <img src="../assets/img/wmms-blk.svg" alt="Symbol">
                             </div>
                         </div>
                     </div>
                 </div>
             </footer>

         </div>



     </div>

     <script type="text/javascript" src="../assets/js/jquery_003.js"></script>
     <script type="text/javascript" src="../assets/js/utils.js"></script>


     <!--[if gte IE 9 | !IE ]><!-->
     <script src="../assets/js/jquery_002.js"></script>
     <script src="../assets/js/wet-boew.js"></script>
     <span id="wb-rsz" class="wb-init">&nbsp;</span>
     <!--<![endif]-->



     <script src="../assets/js/theme.js"></script>


 </body>

 </html>