<?php
include('../../include/db_conx.php');

?>

﻿
<!DOCTYPE html>

<html class="js backgroundsize borderimage csstransitions fontface svg details progressbar meter mathml cors largeview wb-enable" dir="ltr" xmlns="http://www.w3.org/1999/xhtml" lang="en">
<!--<![endif]-->

<head prefix="og: http://ogp.me/ns#">
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">

    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta charset="utf-8">
    <title>Terms and conditions — Immigration, Refugees and Citizenship</title>
    <meta content="width=device-width,initial-scale=1" name="viewport">
    <link rel="schema.dcterms" href="index.html">

    <link rel="canonical" href="../../index.php" />

    <link rel="stylesheet" href="../../assets/css/wet-boew.css">
    <link rel="stylesheet" href="../../assets/css/theme.css">
    <link rel="stylesheet" href="../../assets/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">

    <!--[if gte IE 9 | !IE ]><!-->
    <link rel="apple-touch-icon" sizes="57x57 72x72 114x114 144x144 150x150" class="wb-favicon" href="../../assets/img/favicon.png">
    <link href="../../assets/img/favicon.png" rel="shortcut icon" type="image/png" class="wb-init wb-favicon-inited">
    <link rel="stylesheet" href="../../assets/css/font-awesome.css">
    <script src="../../../use.fontawesome.com/4b789087e7.js"></script>

    <style>
        .view {
            background: #2597c7;
            color: #fff;
            padding: 3px 5px;
            font-size: small;
            -moz-border-radius: 5px;
            -ms-border-radius: 5px;
            -webkit-border-radius: 5px;
            border-radius: 5px;
        }

        .message {
            background: #080;
            color: #fff;
            padding: 3px 5px;
            font-size: small;
            -moz-border-radius: 5px;
            -ms-border-radius: 5px;
            -webkit-border-radius: 5px;
            border-radius: 5px;
        }

        .delete {
            background: #f00;
            color: #fff;
            padding: 3px 5px;
            font-size: small;
            -moz-border-radius: 5px;
            -ms-border-radius: 5px;
            -webkit-border-radius: 5px;
            border-radius: 5px;
        }
    </style>
</head>

<body vocab="http://schema.org/" typeof="WebPage">


    <div class="par iparys_inherited">

        <div class="global-header">
            <nav>
                <ul id="wb-tphp" class="wb-init wb-disable-inited">
                    <li class="wb-slc"><a class="wb-sl" href="#wb-cont">Skip to main content</a></li>
                    <li class="wb-slc"><a class="wb-sl" href="#wb-info">Skip to "About government"</a></li>

                    <li class="wb-slc"><a class="wb-sl" rel="alternate" href="index.html">Switch to basic HTML version</a></li>
                </ul>
            </nav>

            <header>
                <div id="wb-bnr" class="container">

                    <section id="wb-lng" class="text-right">
                        <h2 class="wb-inv">Language selection</h2>
                        <div class="row" style="margin-top:20px">
                            <div class="col-md-12">
                                <ul class="list-inline margin-bottom-none">
                                    <li>
                                        <a href="../../fr/avis/index.php" lang="fr">
                                            Français

                                        </a>
                                    </li>


                                </ul>
                            </div>
                        </div>
                    </section>
                    <div class="row">
                        <div class="brand col-xs-5 col-md-4" property="publisher" typeof="GovernmentOrganization">


                            <a href="../../index.html" property="url">
                                <img src="../../assets/img/sig-blk-en.svg" alt="" property="logo">
                                <span class="wb-inv" property="name"> Government</span>
                            </a>

                            <meta property="areaServed" typeof="Country" content="">
                            <link property="logo" href="../../assets/img/wmms-blk.svg">
                        </div>

                    </div>
                </div>
                <nav class="gcweb-v2 gcweb-menu wb-init gcweb-menu-inited" typeof="SiteNavigationElement" id="wb-auto-2">
                    <div class="container">


                    </div>
                </nav>



                <nav id="wb-bc" property="breadcrumb">
                    <h2 class="wb-inv">You are here:</h2>
                    <div class="container">
                        <ol class="breadcrumb">
                            <li><a href="../../index.php"><?php echo $sitelink ?></a></li>
                            <li><a href="../index.php">Immigration, Refugees and Citizenship</a></li>
                            <li><a href="#">Corporate information</a></li>
                        </ol>
                    </div>
                </nav>


            </header>
        </div>



    </div>
    <main property="mainContentOfPage" resource="#wb-main" typeof="WebPageElement" class="container">


        <h1 property="name" id="wb-cont" dir="ltr">
            Terms and conditions — Immigration, Refugees and Citizenship</h1>




        <div>
            <div class="mwsbodytext text parbase section">



                <p>These terms and conditions are specific to Immigration, Refugees and Citizenship. The following terms and conditions also apply:</p>
                <ul>
                    <li>Using files located on non-Government servers</li>
                    <li>Providing content in official languages</li>
                    <li>Linking to non-Government websites</li>
                    <li>Our commitment to accessibility</li>
                </ul>




            </div>
            <div class="mwsbodytext text parbase section">



                <h2>On this page</h2>



            </div>
            <div class="mwsbodytext text parbase section">



                <ul>
                    <li><a href="#privacy">Privacy notices<span class="nowrap"></span></a></li>
                    <li><a href="#improve">Improving your experience on our website</a></li>
                    <li><a href="#ownership">Ownership and usage of content provided on this site</a></li>
                    <li><a href="#social">Social media</a></li>
                </ul>




            </div>
            <div class="mwshorizontalrule parbase section">
                <hr>
            </div>
            <div class="mwsbodytext text parbase section">



                <h2 id="privacy">Privacy notices</h2>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>We are committed to providing websites that respect the
                    privacy of visitors. This privacy notice summarizes the privacy policy
                    and practices for our online activities.</p>
                <p>All personal information collected by this institution is governed by the <a href="http://laws-lois.justice.gc.ca/eng/acts/P-21/index.html">Privacy Act</a>.
                    This means that you will be informed of the purpose for which your
                    personal information is being collected and how to exercise your right
                    of access to that information.</p>
                <p>Any questions, comments, concerns or complaints you may have regarding the administration of the <a href="http://laws-lois.justice.gc.ca/eng/acts/P-21/index.html">Privacy Act</a>, and privacy policies regarding our web presence may be directed to our Access to Information and Privacy Division.</p>
                <p>If you are not satisfied with our response to your privacy concern, contact the <a href="http://www.priv.gc.ca/index_e.asp">Office of the Privacy Commissioner</a> .</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Your privacy and the Internet</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>The nature of the Internet is such that web servers
                    automatically collect certain information about a visit to a website,
                    including the visitor's Internet Protocol (IP) address. IP addresses are
                    unique numbers assigned by Internet Service Providers (ISP) to all
                    devices used to access the Internet. Web servers automatically log the
                    IP addresses of visitors to their sites. The IP address, on its own,
                    does not identify an individual. However, in certain circumstances, such
                    as with the co-operation of an ISP for example, it could be used to
                    identify an individual using the site. For this reason, we consider the
                    IP address to be personal information, particularly when combined with
                    other data automatically collected when visitor requests a web page such
                    as the page or pages visited, date and time of the visit.</p>
                <p>Unless otherwise noted, we do not automatically gather any specific
                    information from you, such as your name, telephone number or email
                    address. We would obtain this type of information only if you supply it
                    to us, for example, by email or by filling in a contact form. In such
                    cases, how your personal information is handled will be provided in a
                    Personal Information Collection Statement.</p>
                <p>In cases where services are provided by organizations outside of the
                    Government, such as social media platforms or mobile
                    applications, IP addresses may be recorded by the web server of the
                    third-party service provider.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Communicating with us</h3>




            </div>
            <div class="mwsbodytext text parbase section">



                <p>If you choose to send us an email or complete a feedback form
                    online, your personal information is used in order to respond to your
                    inquiry. The information you provide will only be shared with another
                    government institution if your inquiry relates to that institution. We
                    do not use the information to create individual profiles nor does it
                    disclose the information to anyone other than to those in the federal
                    government who need to provide you with a response. Any disclosure of
                    your personal information is in accordance with the <a href="http://laws-lois.justice.gc.ca/eng/acts/P-21/index.html">Privacy Act</a>.</p>
                <p>Personal information from emails or completed feedback forms is collected pursuant to the <a href="http://laws.justice.gc.ca/eng/acts/C-29.4/index.html">Department of Citizenship and Immigration Act</a>, the <a href="http://laws.justice.gc.ca/eng/acts/I-2.5/index.html">Immigration and Refugee Protection Act</a> and the <a href="http://laws.justice.gc.ca/eng/acts/C-29/index.html">Citizenship Act</a>. Such information may be used for statistical, evaluation and reporting purposes and is included in Personal Information Bank <a href="http://www.infosource.gc.ca/emp/emp03-eng.asp#psu914">Public Communications (PSU 914)</a>.</p>




            </div>
            <div class="mwsgeneric-base-html parbase section">



                <h3 id="email">Signing up for our email updates</h3>
                <p>If you complete an online form to subscribe to our email updates,
                    we'll use the information you provide to send you the updates.</p>
                <p>Providing your personal information is voluntary and is only needed
                    if you request to receive this information. We won't use your personal
                    information for any other purpose unless specified otherwise at the
                    point of email entry.</p>
                <p>Personal information is collected pursuant to the <a href="http://laws.justice.gc.ca/eng/acts/C-29.4/index.html">Department of Citizenship and Immigration Act</a>, the&nbsp;<a href="http://laws.justice.gc.ca/eng/acts/I-2.5/index.html">Immigration and Refugee Protection Act</a>, the <a href="http://laws.justice.gc.ca/eng/acts/C-29/index.html">Citizenship Act</a>, the <a href="https://laws-lois.justice.gc.ca/eng/acts/f-11/">Financial Administration Act</a> and in accordance with the <a href="https://www.tbs-sct.gc.ca/pol/doc-eng.aspx?id=30683">Policy on Communications and Federal Identity</a>.</p>
                <p>The <a href="https://laws-lois.justice.gc.ca/eng/acts/P-21/index.html">Privacy Act</a> gives individuals the right of access to, protection and correction of their personal information.</p>
                <p>The standard <a href="http://www.infosource.gc.ca/emp/emp03-eng.asp#psu914">Personal Information Bank PSU 914</a>
                    (entitled Public Communications) further describes the collection,
                    use, disclosure and retention of your personal information.</p>
                <p>If you're not satisfied with how we handle your personal information, you may <a href="https://www.priv.gc.ca/en/report-a-concern/file-a-formal-privacy-complaint/">file a complaint with the Office of the Privacy Commissioner</a>.</p>



            </div>
            <div class="mwsbodytext text parbase section">



                <h3 id="ctc_wiz">Come to Wizard</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>The information within the Come to Wizard is presented
                    to guide you in assessing your suitability for various immigration
                    applications. No immigration decision will be made based on the answers
                    that you provide within the Come to Wizard. If you choose to
                    apply, your application will be considered by an officer in accordance
                    with the Immigration and Refugee Protection Act, without regard to any
                    outcome you attain through this questionnaire.</p>
                <p>The Wizard together with the application guides were designed to
                    provide general guidance to applicants; however, in some cases,
                    additional information or steps may be required.</p>
                <p>You will provide information to the Come to Wizard. The
                    information that you provide will be used to direct you to information
                    concerning the process and documents to be completed and/or submitted in
                    relation to the application that you choose. In the event that you use
                    the Personal Checklist Code provided to you by the Wizard to start an
                    online application within your account, the Wizard information will be
                    retrieved for your review, and will be used to validate responses that
                    you provide on your application form. Should your information change,
                    you may be sent back to the Wizard to validate the information that you
                    provided. The information that you provide may also be used to direct
                    your application(s) to the appropriate office for processing and will be
                    used to gather statistics concerning the use of the Come to Wizard.</p>
                <p>If you complete the Come to Wizard, and receive a Personal
                    Checklist Code, the information that you provide within the Come to
                    Wizard will be stored anonymously within a database for 60 days.
                    If you do not receive a Personal Checklist Code, your information will
                    not be retained once you exit your session. In the event that you submit
                    an online application via your account, the information you provide in
                    the Wizard will be held within the Personal Information Bank that
                    corresponds to the application that you submit, and for the period of
                    time specified within that Personal Information Bank. In accordance with
                    the Privacy Act and the Access to Information Act individuals have a
                    right to protection of and access to their personal information. More
                    information on Personal Information Banks is available at the Infosource
                    website. Infosource is also available at public libraries.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Third-party social media</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>Personal information that you provide via social media account(s) is collected under the authority of
                    the <a href="http://laws.justice.gc.ca/eng/acts/C-29.4/index.html">Department of Citizenship and Immigration Act</a>, the <a href="http://laws.justice.gc.ca/eng/acts/I-2.5/index.html">Immigration and Refugee Protection Act</a> and the <a href="http://laws.justice.gc.ca/eng/acts/C-29/index.html">Citizenship Act</a>.
                    This information is collected to capture conversations (e.g. questions
                    and answers, comments, "likes", retweets). It may be used to respond to
                    inquiries, or for statistical, evaluation and reporting purposes.
                    Comments posted that violate Canadian law will be deleted and disclosed
                    to law enforcement authorities. Comments that violate our rules of
                    engagement will also be deleted. The personal information is included in
                    Personal Information Bank <a href="http://www.infosource.gc.ca/emp/emp03-eng.asp#psu938">Outreach Activities (PSU 938)</a>.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h2 id="improve">Improving your experience on our website</h2>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Digital markers (including cookies)</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>A digital marker is a resource created by the visitors'
                    browser in order to remember certain pieces of information for the web
                    server to reference during the same or subsequent visit to the website.
                    Examples of digital markers are "cookies" or HTML5 web storage. Some
                    examples of what digital markers do are as follows:</p>
                <ul>
                    <li>they allow a website to recognize a previous visit each time the visitor accesses the site;</li>
                    <li>they track what information is viewed on a site which helps website
                        administrators ensure visitors find what they are looking for.</li>
                </ul>
                <p>We use sessional and persistent digital markers on some portions of
                    its website. During your on-line visit, your browser exchanges data with
                    our web server. The digital markers used do not allow IRCC to identify
                    individuals.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Web analytics</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>Web analytics is the term used for the collection, analysis,
                    measurement and reporting of data about Web traffic and visits, for
                    purposes of understanding and optimizing Web usage.</p>
                <p>Information in digital markers may be used for the purpose of Web
                    analytics to remember your online interactions with our website. When
                    you visit our website, we collect the following information:</p>
                <ul>
                    <li>IP address of the device (which is not stored or retained in a format that can be used to identify a visitor)</li>
                    <li>type of browser</li>
                    <li>type of operating system</li>
                    <li>the date and time of the visit</li>
                    <li>pages visited and documents downloaded</li>
                </ul>
                <p>This personal information is not used for decision-making processes
                    about an individual or to profile individual visitors to caimmigrationchecker.com.</p>
                <p>We use services from 2 third-party service providers, Adobe Systems
                    Inc. (Adobe Analytics) and Google Inc. (Google Analytics), to improve
                    our website. To protect information about visitors to our website, we
                    use a feature from each service provider that hides part or all of the
                    IP address of the visitor before it is stored.</p>

                <p>In addition, Adobe and Google operate servers in other countries on
                    which the Web analytics data may be processed. Consequently, the data
                    may be subject to the governing legislation of the country where it is
                    processed.</p>
                <p>For Adobe Analytics, it was specified that
                    personal information can only be stored on servers in Canada, the U.S.,
                    the European Union, Australia, Israel, New Zealand, Norway and
                    Switzerland.</p>
                <p>For more information about their privacy policies:</p>
                <ul>
                    <li><a href="https://www.adobe.com/ca/privacy/experience-cloud.html" rel="external">Adobe Marketing Cloud Privacy</a></li>
                    <li><a href="https://www.google.com/policies/privacy/partners/" rel="external">Google Analytics Privacy &amp; Terms</a></li>
                </ul>
                <p>Information used for the purpose of Web analytics is collected pursuant to the <a href="http://laws.justice.gc.ca/eng/acts/C-29.4/index.html">Department of Citizenship and Immigration Act</a>, the <a href="http://laws.justice.gc.ca/eng/acts/I-2.5/index.html">Immigration and Refugee Protection Act</a> and the <a href="http://laws.justice.gc.ca/eng/acts/C-29/index.html">Citizenship Act</a>.
                    Such data may be used for communications and information technology
                    statistics, audit, evaluation, research, planning and reporting.</p>
                <p>For more information on how your privacy is safeguarded in relation to Web analytics, see the <a href="https://www.tbs-sct.gc.ca/pol/doc-eng.aspx?id=26761">Standard on Privacy and Web Analytics</a>.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Protecting the security of our websites</h3>




            </div>
            <div class="mwsbodytext text parbase section">



                <p>We employ software programs to monitor network traffic to
                    identify unauthorized attempts to upload or change information, or
                    otherwise cause damage. This software receives and records the IP
                    address of the computer that has contacted our website, the date and
                    time of the visit and the pages visited. We make no attempt to link
                    these addresses with the identity of individuals visiting our site
                    unless an attempt to damage the site has been detected.</p>
                <p>This information is collected pursuant to <a href="http://laws-lois.justice.gc.ca/eng/acts/f-11/FullText.html#s-161">section 161 of the Financial Administration Act</a>.
                    The information may be shared with appropriate law enforcement
                    authorities if suspected criminal activities are detected. Such
                    information may be used for network security related statistical
                    purposes, audit, evaluation, research, planning and reporting and is
                    included in Personal Information Bank <a href="http://www.infosource.gc.ca/emp/emp03-eng.asp#psu939">Security Incidents (PSU 939)</a>.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3 id="passport-disclaimer">Canadian passport property ownership</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>All issued passports and travel documents are the
                    property of the Government pursuant to the Passport
                    Order. Any reference to "your passport" or "your child's passport" on
                    this website is for ease of communication only and does not refer to
                    property ownership.</p>
                <h3>Accessibility</h3>
                <p>We are committed to achieving a high standard of accessibility as defined in the <a href="http://www.tbs-sct.gc.ca/pol/doc-eng.aspx?id=23601">Standard on Web Accessibility</a> and the <a href="https://www.tbs-sct.gc.ca/pol/doc-eng.aspx?id=27088">Standard on Optimizing Websites and Applications for Mobile Devices</a>.
                    In the event of difficulty using our web pages, applications or
                    device-based mobile applications, please contact us for assistance or to
                    obtain alternative formats such as regular print, Braille or another
                    appropriate format.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h2 id="ownership">Ownership and usage of content provided on this site</h2>




            </div>
            <div class="mwsbodytext text parbase section">



                <p>Materials on this website were produced and/or compiled by
                    Immigration, Refugees and Citizenship for the purpose of
                    providing Canadians with direct access to information about the programs
                    and services offered by the Government. You may use and
                    reproduce the materials as follows:</p>
                <p>The material on this site is covered by the provisions of the <a href="http://laws.justice.gc.ca/en/C-42/">Copyright Act</a>,
                    by Canadian laws, policies, regulations and international agreements.
                    Such provisions serve to identify the information source and, in
                    specific instances, to prohibit reproduction of materials without
                    written permission.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Non-commercial reproduction</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>Unless otherwise specified you may reproduce the materials in
                    whole or in part for non-commercial purposes, and in any format,
                    without charge or further permission, provided you do the following:</p>
                <ul>
                    <li>Exercise due diligence in ensuring the accuracy of the materials reproduced;</li>
                    <li>Indicate both the complete title of the materials reproduced, as well as the author (where available); and</li>
                    <li>Indicate that the reproduction is a copy of the version available at [URL where original document is available].</li>
                </ul>




            </div>
            <div class="mwsbodytext text parbase section">



                <h3>Commercial reproduction</h3>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>Unless otherwise specified, you may not reproduce materials
                    on this site, in whole or in part, for the purposes of commercial
                    redistribution without prior written permission from Immigration,
                    Refugees and Citizenship.</p>
                <p>Some of the content on this site may be subject to the copyright of
                    another party. Where information has been produced or copyright is not
                    held by Government, the materials are protected under the <a href="http://laws-lois.justice.gc.ca/eng/acts/C-42/index.html">Copyright Act</a>, and international agreements. Details concerning copyright ownership are indicated on the relevant page(s).</p>
                <p>To obtain permission to reproduce our materials on this site for
                    commercial purposes, please apply for Crown Copyright Clearance.</p>




            </div>
            <div class="mwspagination section">

                <p><a class="btn btn-primary" href="https://secure.cic.gc.ca/ccc-ada/step-etape-1-eng.aspx">Apply for Crown Copyright Clearance</a></p>



            </div>
            <div class="mwsbodytext text parbase section">



                <p>To obtain additional information concerning copyright ownership and restrictions, please contact:</p>
                <p class="mrgn-lft-lg">Immigration, Refugees and Citizenship<br>
                    Publishing and Creative Services<br>
                    300 Slater Street, 3<sup>rd</sup>&nbsp;floor&nbsp;<br>
                    Ottawa, Ontario<br>
                    K1A 1L1</p>
                <h3>Trademark notice</h3>
                <p>The official symbols of the Government, including the
                    wordmark, and the flag symbol may not be
                    reproduced, whether for commercial or non-commercial purposes, without written authorization.</p>




            </div>
            <div class="mwsbodytext text parbase section">



                <h2 id="social">Social media</h2>
                <h3>Third party service providers</h3>
                <p>The servers that host our social media platforms are managed by a
                    third party. There may be occasional periods when the servers are not
                    functioning properly. This is out of our control and we accept no
                    responsibility for platforms becoming unresponsive or unavailable.</p>
                <p>Information offered by non-Government sites is not subject to the <a href="http://laws-lois.justice.gc.ca/eng/acts/P-21/index.html">Privacy Act</a> or the <a href="http://laws-lois.justice.gc.ca/eng/acts/O-3.01/">Official Languages Act</a> and may not be accessible to persons with disabilities.</p>
                <p>The Government has no control over the social media
                    platform providers' Terms of Service/Use; you are strongly encouraged to
                    read them in addition to those that follow. Visitors should research
                    the privacy policies of these non-government websites before providing
                    personal information.</p>
                <h3>Content</h3>
                <p>We use social media as an alternative method to interact with users
                    and stakeholders in regard to our programs and services. We will read
                    comments and participate in discussions on our social media channels,
                    when we deem it appropriate. When you "follow", "like" or "subscribe",
                    you can expect to see information about the programs and services we
                    provide.</p>
                <p>We will not engage in issues of party politics or answer questions of a partisan political nature.</p>
                <p>We cannot respond to case-specific questions and we ask users to not
                    post any personal information, and reserve the right to remove this
                    content.</p>
                <h3>Sharing</h3>
                <p>The statements on Non-Commercial Reproduction and Commercial Reproduction apply to content posted to our social media accounts.</p>
                <p>Provided that this content is not altered in any way, users are
                    encouraged to use the tools and features offered by social media
                    platforms to circulate it more broadly (for example: sharing, embedding,
                    and re-tweeting). We do not verify or confirm the accuracy of the
                    content re-posted or shared by users. The views and opinions are those
                    of the author(s) and do not necessarily reflect those of the department
                    or the Government.</p>
                <h3>Frequency</h3>
                <p>While social media operates 24/7, our social media channels are
                    regularly managed during business hours Monday to Friday (EST). We may
                    post new content at any time in the event of an emergency, or if the
                    content could be of significant value to our social media community.
                    Regardless of when we post new content, we will not respond to comments
                    or questions outside of regular business hours, on weekends, or on
                    statutory holidays. We aim to respond to all questions within 2 business
                    days. We may remove content from our social media accounts without
                    notice.</p>
                <h3>Following, favouring, and subscribing</h3>
                <p>There is no implied endorsement of an account, channel, page, individual, group or site should we:</p>
                <ul>
                    <li>decide to "follow," "favourite", "subscribe" or use similar feature to another social media account</li>
                    <li>share content from another user (e,g., re-tweeting, reposting or linking to)</li>
                    <li>use a "Like", thumbs up, "Favorite" or other similar feature for content posted by another user or account.</li>
                </ul>
                <h3>Comments and private messaging</h3>
                <p>The views and opinions expressed by users interacting with our social
                    media posts (for example: commenting on our Facebook or YouTube
                    channels, or including our "handles" in a tweet) are those of the
                    author(s) and do not reflect those of the department or the Government
                    .</p>
                <p>IRCC may remove content or block users based on the following:</p>
                <ul>
                    <li>expression of racist, hateful, sexist, homophobic, slanderous, insulting, or life-threatening messages</li>
                    <li>unproven, or inaccurate accusations against individuals or organizations</li>
                    <li>aggressive, coarse, violent, obscene, or pornographic content</li>
                    <li>offensive, rude, or abusive behaviour to an individual or an organization</li>
                    <li>self-promoting activities</li>
                    <li>encouraging illegal activity</li>
                    <li>announcements from labour or political organizations</li>
                    <li>content that is repetitive or spam that prevents equal service to all users</li>
                    <li>contains personal information</li>
                    <li>contrary to the principles of the Canadian Charter of Rights and Freedoms</li>
                </ul>
                <p>In short, please be respectful and make sure that your comments are
                    relevant to where they are posted. The views of users commenting on our
                    social media accounts do not necessarily represent the views of the
                    Government.</p>
                <h4 id="chatbot">Interacting with our chatbot</h4>
                <p>When you communicate with us on Facebook Messenger, your first
                    interaction will be with Quaid, a chatbot that helps us respond to your
                    questions. If Quaid can't answer your question, it will ask one of our
                    agents to answer the question instead.</p>
                <p>There are several things to keep in mind when chatting with Quaid, or with us directly.</p>
                <h5>Quaid's responses are general and based on people's typical circumstances.</h5>
                <p>Your situation may be different, and the answer may not apply to your situation.</p>
                <h5>Responses from Quaid or our agents won't impact your application.</h5>
                <p>Your conversations with Quaid or our agents:</p>
                <ul>
                    <li>don't guarantee we'll accept your application (it's up to our officers to decide)</li>
                    <li>are not connected to your application or account with us</li>
                    <li>don't replace advice from authorized representatives</li>
                </ul>
                <h5>We may end any Messenger conversations that violate our terms and conditions.</h5>
                <p>If we block you for violating our terms and conditions, you can't use this channel to communicate with us in the future.</p>
                <h5>We may store your question to help train Quaid.</h5>
                <p>The more questions it handles, the smarter Quaid becomes. However, we
                    don't store or use your profile information, post history or other
                    interactions to train it.</p>
                <h3>Official languages</h3>
                <p>We will reply to questions and comments in the official language in
                    which they are posted. If we consider the response to be a matter of
                    general public interest, we may respond in both official languages.</p>
                <p>We may share links that direct users to websites of organizations or other entities that are not subject to the <a href="http://laws-lois.justice.gc.ca/eng/acts/O-3.01/">Official Languages Act</a>.
                    When external content is not available in both French and English, we
                    will try to provide similar content in the other official language.
                    Information provided in a language other than English or French is only
                    for the convenience of our visitors.</p>
            </div>

        </div>
        <div class="pagedetails ">
            <dl id="wb-dtmd">
                <dt>Date modified:</dt>
                <dd><time property="dateModified">2022-08-19</time></dd>
            </dl>
        </div>
    </main>



    <div class="par iparys_inherited">


        <div class="global-footer">
            <footer id="wb-info">

                <div class="brand">
                    <div class="container">
                        <div class="row">
                            <nav class="col-md-10 ftr-urlt-lnk">

                            </nav>
                            <div class="col-xs-6 visible-sm visible-xs tofpg">
                                <a href="#wb-cont">Top of page <span class="fa fa-chevron-up"></span></a>
                            </div>
                            <div class="col-xs-6 col-md-2 text-right">
                                <img src="../../assets/img/wmms-blk.svg" alt="Symbol">
                            </div>
                        </div>
                    </div>
                </div>
            </footer>

        </div>



    </div>

    <script type="text/javascript" src="../../assets/js/jquery_003.js"></script>
    <script type="text/javascript" src="../../assets/js/utils.js"></script>


    <!--[if gte IE 9 | !IE ]><!-->
    <script src="../../assets/js/jquery_002.js"></script>
    <script src="../../assets/js/wet-boew.js"></script>
    <span id="wb-rsz" class="wb-init">&nbsp;</span>
    <!--<![endif]-->



    <script src="../../assets/js/theme.js"></script>


</body>

</html>