<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bouncing Green Rectangle Boxes</title>
    <style>
        body,
        html {
            margin: 0;
            padding: 0;
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #000;
        }

        .box-wrap {
            width: 280px;
            height: 500px;
            border: 2px solid lime;
            position: relative;
            overflow: hidden;
            display: flex;
            /* justify-content: space-around; */
            align-items: flex-end;
            gap: 8px;
            /* Reduce spacing between boxes */
        }

        .green-box {
            width: 20px;
            background-color: lime;
            box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1);
            position: relative;
            bottom: 0;
        }

        /* Define unique heights and faster animation timings for each box */
        .green-box:nth-child(1) {
            height: 100px;
            animation: bounceHeight 0.4s ease-in-out infinite;
            /* Faster animation */
        }

        .green-box:nth-child(2) {
            height: 120px;
            animation: bounceHeight 0.5s ease-in-out infinite;
            /* Faster animation */
        }

        .green-box:nth-child(3) {
            height: 140px;
            animation: bounceHeight 0.6s ease-in-out infinite;
            /* Faster animation */
        }

        .green-box:nth-child(4) {
            height: 160px;
            animation: bounceHeight 0.7s ease-in-out infinite;
            /* Faster animation */
        }

        .green-box:nth-child(5) {
            height: 180px;
            animation: bounceHeight 0.8s ease-in-out infinite;
            /* Faster animation */
        }

        .green-box:nth-child(6) {
            height: 200px;
            animation: bounceHeight 0.9s ease-in-out infinite;
            /* Faster animation */
        }

        .green-box:nth-child(7) {
            height: 220px;
            animation: bounceHeight 1s ease-in-out infinite;
            /* Faster animation */
        }

        /* Bouncing animation (only height changes) */
        @keyframes bounceHeight {
            0% {
                height: var(--initial-height);
            }

            50% {
                height: calc(var(--initial-height) + 50px);
            }

            100% {
                height: var(--initial-height);
            }
        }
    </style>
</head>

<body>
    <!-- Container for green boxes -->
    <div class='box-wrap'>
        <!-- 7 green boxes -->
        <div class="green-box" style="--initial-height: 100px;"></div>
        <div class="green-box" style="--initial-height: 120px;"></div>
        <div class="green-box" style="--initial-height: 140px;"></div>
        <div class="green-box" style="--initial-height: 60px;"></div>
        <div class="green-box" style="--initial-height: 90px;"></div>
        <div class="green-box" style="--initial-height: 200px;"></div>
        <div class="green-box" style="--initial-height: 220px;"></div>
    </div>
</body>

</html>